// Live Strength Meter Logic
function checkStrength(password) {
    let meter = document.getElementById('password-strength');
    if (password.length === 0) {
        meter.innerHTML = "";
    } else if (password.length < 6) {
        meter.innerHTML = "⚠️ Password too weak";
        meter.style.color = "#EF4444";
    } else if (password.length < 10) {
        meter.innerHTML = "🟡 Moderate strength";
        meter.style.color = "#F59E0B";
    } else {
        meter.innerHTML = "✅ Strong password";
        meter.style.color = "#10B981";
    }
}

// Router Logic for Pathing (login vs signup)
function handleRouting() {
    const hash = window.location.hash;
    const loginSec = document.getElementById('login-section');
    const signupSec = document.getElementById('signup-section');

    if (hash === "#signup") {
        loginSec.style.display = "none";
        signupSec.style.display = "block";
        signupSec.classList.add('fade-in');
    } else {
        signupSec.style.display = "none";
        loginSec.style.display = "block";
        loginSec.classList.add('fade-in');
    }
}

// Password Visibility Toggle
function togglePass(id) {
    const input = document.getElementById(id);
    const icon = input.nextElementSibling;
    if (input.type === "password") {
        input.type = "text";
        icon.classList.replace('ri-eye-off-line', 'ri-eye-line');
    } else {
        input.type = "password";
        icon.classList.replace('ri-eye-line', 'ri-eye-off-line');
    }
}

window.addEventListener('hashchange', handleRouting);
window.addEventListener('load', handleRouting);