const esimData = [
  // =====================
  // POPULAR DESTINATIONS
  // =====================
  { name: "United States", price: "3.59", img: "https://flagcdn.com/w160/us.png", type: "popular" },
  { name: "United Kingdom", price: "4.25", img: "https://flagcdn.com/w160/gb.png", type: "popular" },
  { name: "Japan", price: "5.10", img: "https://flagcdn.com/w160/jp.png", type: "popular" },
  { name: "Canada", price: "4.80", img: "https://flagcdn.com/w160/ca.png", type: "popular" },
  { name: "France", price: "4.50", img: "https://flagcdn.com/w160/fr.png", type: "popular" },
  { name: "Germany", price: "4.60", img: "https://flagcdn.com/w160/de.png", type: "popular" },
  { name: "United Arab Emirates", price: "5.20", img: "https://flagcdn.com/w160/ae.png", type: "popular" },

  // =====================
  // AFRICA
  // =====================
  { name: "Nigeria", price: "6.00", img: "https://flagcdn.com/w160/ng.png", type: "africa" },
  { name: "South Africa", price: "6.50", img: "https://flagcdn.com/w160/za.png", type: "africa" },
  { name: "Kenya", price: "6.20", img: "https://flagcdn.com/w160/ke.png", type: "africa" },
  { name: "Ghana", price: "6.10", img: "https://flagcdn.com/w160/gh.png", type: "africa" },
  { name: "Egypt", price: "6.40", img: "https://flagcdn.com/w160/eg.png", type: "africa" },

  // =====================
  // EUROPE
  // =====================
  { name: "Spain", price: "4.70", img: "https://flagcdn.com/w160/es.png", type: "europe" },
  { name: "Italy", price: "4.75", img: "https://flagcdn.com/w160/it.png", type: "europe" },
  { name: "Netherlands", price: "4.60", img: "https://flagcdn.com/w160/nl.png", type: "europe" },
  { name: "Switzerland", price: "5.30", img: "https://flagcdn.com/w160/ch.png", type: "europe" },
  { name: "Portugal", price: "4.65", img: "https://flagcdn.com/w160/pt.png", type: "europe" },

  // =====================
  // ASIA
  // =====================
  { name: "China", price: "5.90", img: "https://flagcdn.com/w160/cn.png", type: "asia" },
  { name: "South Korea", price: "5.50", img: "https://flagcdn.com/w160/kr.png", type: "asia" },
  { name: "Singapore", price: "5.40", img: "https://flagcdn.com/w160/sg.png", type: "asia" },
  { name: "Thailand", price: "5.30", img: "https://flagcdn.com/w160/th.png", type: "asia" },
  { name: "India", price: "5.60", img: "https://flagcdn.com/w160/in.png", type: "asia" },

  // =====================
  // REGIONAL PLANS
  // =====================
  { name: "Europe Region", price: "12.00", img: "https://flagcdn.com/w160/eu.png", type: "regional" },
  { name: "Asia Pacific", price: "15.50", img: "https://flagcdn.com/w160/un.png", type: "regional" },
  { name: "Africa Region", price: "18.00", img: "https://flagcdn.com/w160/un.png", type: "regional" },
  { name: "North America", price: "14.00", img: "https://flagcdn.com/w160/un.png", type: "regional" },

  // =====================
  // GLOBAL PLANS
  // =====================
  { name: "Global Explorer (50 Countries)", price: "25.00", img: "https://flagcdn.com/w160/un.png", type: "global" },
  { name: "Global Business (100 Countries)", price: "45.00", img: "https://flagcdn.com/w160/un.png", type: "global" }
];

function filterType(category) {
    // Update Buttons
    document.querySelectorAll('.flx-tab-btn').forEach(btn => {
        btn.classList.toggle('active', btn.getAttribute('onclick').includes(category));
    });

    const grid = document.getElementById('destGrid');
    const filtered = esimData.filter(item => item.type === category);

    grid.innerHTML = filtered.map(dest => `
        <div class="flx-dest-card">
            <div class="flx-dest-left">
                <div class="flx-flag-wrap">
                    <img src="${dest.img}" alt="${dest.name}">
                </div>
                <div>
                    <span class="flx-dest-name">${dest.name} eSIM</span>
                    <span class="flx-dest-price">Starts from $${dest.price}</span>
                </div>
            </div>
            <div class="flx-arrow-circle">
                <i class="ri-arrow-right-line"></i>
            </div>
        </div>
    `).join('');
}

// Initial view
filterType('popular');